/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import java.util.Objects;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntity;
import net.blay09.mods.waystones.client.ModRenderers;
import net.blay09.mods.waystones.client.ModTextures;
import net.blay09.mods.waystones.client.render.SharestoneModel;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class WaystoneRenderer
implements BlockEntityRenderer<WaystoneBlockEntity> {
    private static final Material MATERIAL = new Material(ModTextures.SHEET, new ResourceLocation("waystones", "entity/waystone_active"));
    private final SharestoneModel model;

    public WaystoneRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new SharestoneModel(context.m_173582_(ModRenderers.waystoneModel));
    }

    public void render(WaystoneBlockEntity tileEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockState state = tileEntity.m_58900_();
        if (state.m_61143_((Property)WaystoneBlock.HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        float angle = ((Direction)state.m_61143_((Property)WaystoneBlock.FACING)).m_122435_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        matrixStack.m_85845_(new Quaternion(0.0f, angle, 0.0f, true));
        matrixStack.m_85845_(new Quaternion(-180.0f, 0.0f, 0.0f, true));
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean isActivated = PlayerWaystoneManager.isWaystoneActivated((Player)Objects.requireNonNull(player), tileEntity.getWaystone());
        if (isActivated) {
            matrixStack.m_85841_(1.05f, 1.05f, 1.05f);
            VertexConsumer vertexBuilder = MATERIAL.m_119194_(buffer, RenderType::m_110452_);
            int light = WaystonesConfig.getActive().disableTextGlow() ? combinedLightIn : 0xF000F0;
            int overlay = WaystonesConfig.getActive().disableTextGlow() ? combinedOverlayIn : OverlayTexture.f_118083_;
            this.model.m_7695_(matrixStack, vertexBuilder, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrixStack.m_85849_();
    }
}

